(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    556632,      13841]
NotebookOptionsPosition[    544055,      13619]
NotebookOutlinePosition[    544525,      13636]
CellTagsIndexPosition[    544482,      13633]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Orthodiagonal  Quadrilaterals", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 
  3.947144443366682*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about orthodiagonal \
quadrilaterals in the paper \"More Relationships between a Central \
Quadrilateral and its Reference Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 
  3.947148664004244*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptD", "=", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"orthodiagonal", "=", 
   RowBox[{
    RowBox[{"Last", "[", 
     RowBox[{"First", "[", 
      RowBox[{"SonPerpendiculares", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"ptA", ",", "ptC"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"ptB", ",", "ptD"}], "]"}]}], "]"}], "]"}], "]"}], "==", 
    "0"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central  quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 
  3.946441687230852*^9}},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.947157407080984*^9, 3.947157416769724*^9}, 
   3.947159936232693*^9},
 CellLabel->
  "In[106]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 
   3.946437820730978*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal  quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 
  3.9464377702703495`*^9}},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324472`*^9, 
   3.94713348841169*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQl8TNf//z/jT8WjU/1FP3zr86GlaVTzCVrRatCPpIitEVpBidjXWBpq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    "], {{0, 251.32075471698113`}, {729.5094339622641, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{729.5094339622641, 251.32075471698113`},
  PlotRange->{{0, 729.5094339622641}, {0, 251.32075471698113`}}]], "Text",
 CellChangeTimes->{3.946440201275278*^9, 
  3.947156733497298*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[CellGroupData[{

Cell["X (3)", "Subsection",
 CellChangeTimes->{{3.9464396668029766`*^9, 
  3.946439670481838*^9}},ExpressionUUID->"a1a90c2d-df65-ba4e-be23-\
dc80473e3e5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "3", "]"}]}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"26a01fcf-800f-6d4f-b95f-70520405f5db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", "r"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "4"]}], " ", "p", " ", "r"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "r"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "4"]}], " ", "p", " ", "q"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"q", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.946439747579574*^9, 3.946439928198509*^9, 
  3.947133315256377*^9, 3.947567084477974*^9, 3.947567138860012*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"04221dec-bd00-904c-87a9-2914f1ecd410"]
}, Open  ]],

Cell[CellGroupData[{

Cell["stein[ABCD] = dp[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946439704627547*^9, 3.946439707866272*^9}, {
  3.947567151285345*^9, 
  3.947567160157625*^9}},ExpressionUUID->"91071cd9-467f-544d-ba08-\
6eaca339a993"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464397267793617`*^9, 3.9464397915046825`*^9}, {
  3.946439860385023*^9, 3.946439914809219*^9}, {3.947133321979674*^9, 
  3.947133324317803*^9}, {3.9475670743175564`*^9, 3.947567126149168*^9}, {
  3.947567183260372*^9, 3.947567188966831*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"f35c9f52-ccdc-364f-a2d3-b613b672a23e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947133334863653*^9, {3.9475671631613274`*^9, 3.947567190022192*^9}},
 CellLabel->
  "Out[141]=",ExpressionUUID->"d30213e4-671e-4049-a5ab-c5c3c4b6436d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["QA-P4=persp[ABCD,GHEF]=QA-P4", "Subsubsection",
 CellChangeTimes->{{3.946439704627547*^9, 3.946439707866272*^9}, 
   3.946442198526972*^9, {3.94644235006088*^9, 
   3.946442350101139*^9}},ExpressionUUID->"f5f0cab0-60c4-a047-bb26-\
75cb7f6b7f47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464397267793617`*^9, 3.9464397915046825`*^9}, {
  3.946439860385023*^9, 3.946439914809219*^9}, {3.946442209165903*^9, 
  3.9464422985975704`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"7028385f-80f5-a346-a7d1-029708224ad0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946439906690569*^9, 3.946439931535791*^9}, 
   3.946442240130455*^9, {3.946442271704183*^9, 3.946442299408037*^9}, 
   3.9464424296917*^9, 3.946628686168707*^9, 3.946630257154923*^9, 
   3.9471450016660843`*^9, 3.9475672518809223`*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"28ccee70-58d0-5e4b-94bd-6d94ed77560f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"PerspectorConABC", "[", 
   RowBox[{"{", 
    RowBox[{"ptG", ",", "ptH", ",", "ptE"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.946442307456341*^9, 3.946442318741855*^9}, {
  3.946442370373625*^9, 3.946442373028879*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"170c70ec-dfb5-3a48-bb54-4829c4557723"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "4"]}], " ", "p", " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "r"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.94644237399119*^9, 3.946442429719656*^9, 
  3.9466286919743576`*^9, 3.946630258245131*^9, 3.947145007318033*^9, 
  3.947567255218586*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"e36f8a3c-eb06-2642-9792-2c541809ec91"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464424337674017`*^9, 3.946442452566784*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"5ed86be9-b786-8448-8700-b64d50d6ae33"],

Cell[BoxData["\<\"QA-P4\"\>"], "Output",
 CellChangeTimes->{3.947145018338043*^9, 3.9475672593997765`*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"c22f2c31-206e-f847-9750-4fd8dd7b39bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}], "]"}], ",", 
   "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{
  3.946630176513145*^9, {3.946630265937153*^9, 3.946630272672463*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"c2e92eba-77bd-0e4d-bc67-7df87a295b0b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9466301785925636`*^9, 3.9466302742542553`*^9, 
  3.947145025017557*^9, 3.9475672623446217`*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"6c3751c0-7141-4c47-bb01-691833bfccba"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (4)", "Subsection",
 CellChangeTimes->{{3.9464399502118874`*^9, 
  3.9464399534813766`*^9}},ExpressionUUID->"4aa76cac-906f-7f45-be0d-\
637f51ee2a42"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}]], "Input",
 CellChangeTimes->{{3.946440032144888*^9, 3.946440033536398*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"66502e01-3006-f747-9027-cc757f2ca219"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "-", "r"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "-", "q"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "-", "r"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "-", "q"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "q"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "-", "r"}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "-", "r"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ")"}]}],
      ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.946440034309118*^9, 3.9464426983443623`*^9, {3.94663029169149*^9, 
   3.946630309645727*^9}, 3.947145039295503*^9, 3.947567647854767*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"d375dee9-5e6d-0c4b-902c-9db5c6f30228"]
}, Open  ]],

Cell[CellGroupData[{

Cell["dp(ABCD) = dp(EFGH)=ponce[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.946439991106724*^9, 3.946439995394495*^9}, 
   3.9464427002460823`*^9, {3.9466303528002605`*^9, 3.946630356832882*^9}, 
   3.947145044686632*^9},ExpressionUUID->"9fee070d-03d8-a945-9741-\
930a44886dbd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{3.946630330296295*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"81a0a056-7f39-9340-9e68-d3c9445b1222"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946630331407274*^9, 3.947145052654608*^9, 
  3.9475676492711926`*^9},
 CellLabel->
  "Out[151]=",ExpressionUUID->"1d9d5fed-9313-9545-a5e3-d491ba39ed76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.946630375408828*^9, 3.946630381337036*^9}, 
   3.9475676447560616`*^9},
 CellLabel->
  "In[152]:=",ExpressionUUID->"83f22c6f-435a-dc49-9aca-dd68d24544db"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9466303836375465`*^9, 3.947145058732811*^9, 
  3.9475676506401653`*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"c5183373-bf98-f246-8125-a29b6a6aacbe"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (5)", "Subsection",
 CellChangeTimes->{{3.946630391418861*^9, 
  3.946630395865806*^9}},ExpressionUUID->"7579aa88-3a26-8748-be35-\
720b166befd2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "5", "]"}]}]], "Input",
 CellChangeTimes->{{3.946630441832161*^9, 3.94663044796834*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"f62ef83e-680c-6046-8a24-8c0ea442b44e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "-", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.946630448641424*^9, 3.947145067799439*^9, 
  3.9475676890760727`*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"bf406471-8d2c-b74b-a70e-a59f874811bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["m[ABCD] = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946630409323005*^9, 
  3.9466304228083572`*^9}},ExpressionUUID->"300446bc-29bf-9947-82af-\
ad97abd79581"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466304717683277`*^9, 3.9466304753370247`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"7994f72e-8089-0646-bbdb-7647c12b36e5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.94663048071019*^9, 3.9471450771580887`*^9, 
  3.947567698120487*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"0620cb97-511b-b54d-bc97-7a2cdccfdf7e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (25) ", "Subsection",
 CellChangeTimes->{{3.946441433673494*^9, 3.9464414377673607`*^9}, {
   3.946442111605545*^9, 3.946442122581985*^9}, {3.9465596364300537`*^9, 
   3.946559646605116*^9}, 3.946788747050583*^9, 
   3.9475667301096706`*^9},ExpressionUUID->"ec7f99ad-cd97-6841-a2aa-\
def813418c5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "25", "]"}]}]], "Input",
 CellChangeTimes->{3.947566921309414*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"b104ed23-a86c-7b40-9d73-0247036a7461"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "q"}], "+", 
              RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"4", " ", "p", " ", "r"}], "+", 
              RowBox[{"5", " ", "q", " ", "r"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "3"], "+", 
              RowBox[{
               SuperscriptBox["p", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{"q", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{"p", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", "q"}], "+", 
              RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"4", " ", "p", " ", "q"}], "+", 
              SuperscriptBox["q", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "3"], "+", 
              RowBox[{"p", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["q", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"4", " ", "p", " ", "r"}], "+", 
              RowBox[{"5", " ", "q", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["p", "2"]}], "-", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"6", " ", "q", " ", "r"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "q", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q"}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["q", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "-", "r"}], ")"}], " ", "r"}], "-", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         SuperscriptBox["q", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", "q"}], "+", 
              RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"], " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "2"], " ", "r"}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              RowBox[{"6", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "-", 
              RowBox[{"q", " ", "r"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "q"}], "+", 
                 RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], 
        "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", "p", " ", "q"}], "+", 
              SuperscriptBox["q", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"4", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"6", " ", "q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", "q"}], "+", 
              RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"5", " ", "q"}], "+", 
                 RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["p", "2"], " ", "q"}], "+", 
              RowBox[{"r", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
              RowBox[{"p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"5", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"6", " ", "q", " ", "r"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9475669219081116`*^9, 3.9475677127991657`*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"5c8d4769-62b9-3f4f-a40c-f9d6b909e3c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD, GHEF] ", "Subsubsection",
 CellChangeTimes->{{3.946442877247701*^9, 
  3.946442884277727*^9}},ExpressionUUID->"730aa00b-1790-4140-9299-\
5d331bed3f16"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.946441467542467*^9, 3.946441468278334*^9}, 
   3.9464428408933883`*^9, {3.946443040908897*^9, 3.946443042284864*^9}, {
   3.947566880119911*^9, 3.947566883309723*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"9e043c6d-4717-4147-8f3d-1907a65579f6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946441469321218*^9, 3.946442842098461*^9, 3.946443043408647*^9, 
   3.946444453849726*^9, 3.946559661423958*^9, 3.9466305532563095`*^9, 
   3.947145095376484*^9, 3.947156977859946*^9, 3.947157026702408*^9, 
   3.9471570992597904`*^9, 3.947157319391609*^9, 3.947157433168442*^9, 
   3.947158728220394*^9, 3.94756662670343*^9, {3.9475668884119854`*^9, 
   3.9475668927591496`*^9}, 3.947567716428215*^9},
 CellLabel->
  "Out[156]=",ExpressionUUID->"c8f634d9-9047-a847-819b-727281d15cc5"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (68) ", "Subsection",
 CellChangeTimes->{{3.946441433673494*^9, 3.9464414377673607`*^9}, {
   3.946442111605545*^9, 3.946442122581985*^9}, {3.9465596364300537`*^9, 
   3.946559646605116*^9}, 3.946788747050583*^9, {3.947566873708824*^9, 
   3.9475668742615833`*^9}},ExpressionUUID->"2633372d-8391-634c-8e81-\
e1ce5610b771"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "68", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.947566927325136*^9, 3.947566933773056*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"13aa2c70-08df-de4d-9d1e-b89dda97dc04"],

Cell[CellGroupData[{

Cell["persp[ABCD, GHEF] ", "Subsubsection",
 CellChangeTimes->{{3.946442877247701*^9, 
  3.946442884277727*^9}},ExpressionUUID->"8af8dd32-3080-8c41-b091-\
ac7e373d678e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464430575325*^9, 3.9464430681725636`*^9}, {
   3.947158585712944*^9, 3.947158592447138*^9}, 3.947566790277172*^9, {
   3.9475668992146263`*^9, 3.947566902772827*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"6ec6dc4c-8b80-3c44-b090-79f3e979f085"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946443061870685*^9, 3.946443069768987*^9}, 
   3.9465596647173576`*^9, 3.946630556271611*^9, 3.947145099685163*^9, 
   3.947566629926996*^9, 3.947566903364746*^9, 3.947567725269615*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"acfd2fc1-4d35-df48-af88-4df13961fdc0"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (485) ", "Subsection",
 CellChangeTimes->{{3.946441433673494*^9, 3.9464414377673607`*^9}, {
   3.946442111605545*^9, 3.946442122581985*^9}, {3.9465596364300537`*^9, 
   3.946559646605116*^9}, 3.946788747050583*^9, {3.9475668149891186`*^9, 
   3.9475668170129128`*^9}},ExpressionUUID->"382534f7-ae81-104a-a54a-\
dd725e6c4322"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "485", "]"}]}]], "Input",
 CellChangeTimes->{3.947566912293211*^9},
 CellLabel->
  "In[159]:=",ExpressionUUID->"2bb42715-f2a5-db4e-ba25-c5c3a1865990"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}], "-", 
          RowBox[{"2", " ", "p", " ", "S"}], "-", 
          RowBox[{"4", " ", "q", " ", "S"}], "-", 
          RowBox[{"2", " ", "r", " ", "S"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", 
             RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
          RowBox[{"p", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", "S"}], "-", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}], "+", 
          RowBox[{"q", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}], "+", 
          RowBox[{"4", " ", "p", " ", "S"}], "+", 
          RowBox[{"2", " ", "q", " ", "S"}], "+", 
          RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}], "+", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "S"}]}], 
        ")"}]}], "-", 
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", "S"}], "-", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", "p", " ", "S"}], "+", 
        RowBox[{"2", " ", "q", " ", "S"}], "+", 
        RowBox[{"2", " ", "r", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "p", " ", "r"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"], " ", "q", " ", "r"}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "S"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"4", " ", "q", " ", "r", " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"2", " ", "q", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947566912898218*^9, 3.9475677307790565`*^9},
 CellLabel->
  "Out[159]=",ExpressionUUID->"a48fb83b-c052-8741-8f16-8c5b2e914d1e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD, GHEF] ", "Subsubsection",
 CellChangeTimes->{{3.946442877247701*^9, 
  3.946442884277727*^9}},ExpressionUUID->"d092eccb-c9cc-d249-80e8-\
25dec20dd82c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"PerspectiveQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
     "]"}], "/.", "sustS"}], ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9471586131283073`*^9, 3.947158630073631*^9}, {
   3.947566642086073*^9, 3.947566683334099*^9}, 3.947566831798132*^9, {
   3.9475669086464252`*^9, 3.9475669153726883`*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"96174ed5-f42b-b44b-b2c1-87afbe7eeb34"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.947158630817951*^9, {3.9475666552863045`*^9, 3.9475666847421303`*^9}, 
   3.9475669159955063`*^9, 3.947567732754652*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"70c34d44-364b-c641-9e5e-97dcb9084dfb"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (486) ", "Subsection",
 CellChangeTimes->{{3.946441433673494*^9, 3.9464414377673607`*^9}, {
   3.946442111605545*^9, 3.946442122581985*^9}, {3.9465596364300537`*^9, 
   3.946559646605116*^9}, 3.946788747050583*^9, 
   3.9475668411810265`*^9},ExpressionUUID->"e9ba3f29-2836-0e4e-ab8a-\
c890c90e17cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "486", "]"}]}]], "Input",
 CellChangeTimes->{3.9475669429490433`*^9},
 CellLabel->
  "In[161]:=",ExpressionUUID->"a651da95-8488-7c40-8bf3-8b03185c23c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", 
             RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
          RowBox[{"p", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}], "+", 
          RowBox[{"2", " ", "p", " ", "S"}], "+", 
          RowBox[{"4", " ", "q", " ", "S"}], "+", 
          RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", "S"}], "-", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "-", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "r"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", "p", " ", "S"}], "+", 
        RowBox[{"2", " ", "q", " ", "S"}], "+", 
        RowBox[{"2", " ", "r", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}], "+", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}], "+", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "S"}]}], 
        ")"}]}], "+", 
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", "S"}], "+", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", "q"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "-", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "r"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}], "+", 
          RowBox[{"4", " ", "p", " ", "S"}], "+", 
          RowBox[{"2", " ", "q", " ", "S"}], "+", 
          RowBox[{"2", " ", "r", " ", "S"}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", "p", " ", "r"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"], " ", "q", " ", "r"}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "S"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["q", "2"], " ", "S"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", "S"}], "+", 
      RowBox[{"4", " ", "q", " ", "r", " ", 
       SuperscriptBox["S", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947566943475378*^9, 3.9475677387925034`*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"b434c684-4ea8-a848-9ecf-5acb20df5357"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD, GHEF] ", "Subsubsection",
 CellChangeTimes->{{3.946442877247701*^9, 
  3.946442884277727*^9}},ExpressionUUID->"1105f11d-30a3-5847-920b-\
97822c3dcdd8"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"PerspectiveQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
     "]"}], "/.", "sustS"}], ",", "orthodiagonal"}], "]"}]], "Input",
 CellChangeTimes->{{3.9471586444806156`*^9, 3.947158647209337*^9}, {
   3.947566693006941*^9, 3.947566696126116*^9}, 3.947566853717247*^9, {
   3.9475669412468452`*^9, 3.9475669467010765`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"71d4223f-cb25-9b45-ac01-6db1ce83a1ef"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9471586483925734`*^9, 3.947566697434067*^9, 
  3.9475669473562374`*^9, 3.9475677404559555`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"0af2e1a1-f33d-ab44-8c90-6cf78aa91c4f"]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"93784f08-2cb8-a846-8e29-b2284c41a76d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 221, 4, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[782, 26, 1366, 23, 173, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2173, 53, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[2376, 59, 1757, 42, 86, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"]
}, Closed]],
Cell[CellGroupData[{
Cell[4170, 106, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[4450, 114, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[4665, 120, 271223, 7062, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[275925, 7187, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[276143, 7193, 434, 11, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[276580, 7206, 435, 11, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[277018, 7219, 434, 11, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[277455, 7232, 1078, 29, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[278536, 7263, 816, 23, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[279355, 7288, 599, 16, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[279957, 7306, 2069, 53, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[282029, 7361, 1710, 46, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[283742, 7409, 1910, 50, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[285655, 7461, 609, 16, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[286267, 7479, 1127, 29, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[287397, 7510, 1391, 39, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[288791, 7551, 1394, 39, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[290188, 7592, 1326, 38, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[291517, 7632, 1364, 37, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[292918, 7674, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[293212, 7681, 3314, 100, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[296563, 7786, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[296758, 7793, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[296978, 7799, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[350861, 8690, 999, 25, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[351897, 8720, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[352138, 8726, 817, 19, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[352992, 8750, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[353210, 8756, 2076, 57, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[355323, 8818, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[355568, 8824, 664, 16, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[356269, 8845, 175, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[356447, 8850, 1659, 45, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[358143, 8900, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[358320, 8905, 562, 15, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[358919, 8925, 347, 5, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[359269, 8932, 1247, 34, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[360553, 8971, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[360940, 8979, 972, 27, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[361915, 9008, 883, 25, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[362835, 9038, 300, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[363138, 9045, 1686, 41, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[364861, 9091, 179, 3, 37, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[365043, 9096, 1631, 40, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[366711, 9141, 225, 4, 37, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[366939, 9147, 1442, 38, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[368418, 9190, 308, 5, 37, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[368729, 9197, 3090, 71, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[371880, 9275, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[372094, 9281, 66213, 1090, 266, "Text",ExpressionUUID->"20c7ab22-8503-fd4d-9d34-15585b88ac29"],
Cell[CellGroupData[{
Cell[438332, 10375, 155, 3, 54, "Subsection",ExpressionUUID->"a1a90c2d-df65-ba4e-be23-dc80473e3e5c"],
Cell[CellGroupData[{
Cell[438512, 10382, 319, 7, 28, "Input",ExpressionUUID->"26a01fcf-800f-6d4f-b95f-70520405f5db"],
Cell[438834, 10391, 10292, 325, 122, "Output",ExpressionUUID->"04221dec-bd00-904c-87a9-2914f1ecd410"]
}, Open  ]],
Cell[CellGroupData[{
Cell[449163, 10721, 222, 4, 45, "Subsubsection",ExpressionUUID->"91071cd9-467f-544d-ba08-6eaca339a993"],
Cell[CellGroupData[{
Cell[449410, 10729, 701, 15, 28, "Input",ExpressionUUID->"f35c9f52-ccdc-364f-a2d3-b613b672a23e"],
Cell[450114, 10746, 207, 4, 32, "Output",ExpressionUUID->"d30213e4-671e-4049-a5ab-c5c3c4b6436d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[450370, 10756, 251, 4, 45, "Subsubsection",ExpressionUUID->"f5f0cab0-60c4-a047-bb26-75cb7f6b7f47"],
Cell[CellGroupData[{
Cell[450646, 10764, 580, 14, 28, "Input",ExpressionUUID->"7028385f-80f5-a346-a7d1-029708224ad0"],
Cell[451229, 10780, 372, 6, 32, "Output",ExpressionUUID->"28ccee70-58d0-5e4b-94bd-6d94ed77560f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[451638, 10791, 357, 8, 28, "Input",ExpressionUUID->"170c70ec-dfb5-3a48-bb54-4829c4557723"],
Cell[451998, 10801, 3794, 121, 78, "Output",ExpressionUUID->"e36f8a3c-eb06-2642-9792-2c541809ec91"]
}, Open  ]],
Cell[CellGroupData[{
Cell[455829, 10927, 253, 5, 28, "Input",ExpressionUUID->"5ed86be9-b786-8448-8700-b64d50d6ae33"],
Cell[456085, 10934, 189, 3, 32, "Output",ExpressionUUID->"c22f2c31-206e-f847-9750-4fd8dd7b39bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[456311, 10942, 401, 10, 28, "Input",ExpressionUUID->"c2e92eba-77bd-0e4d-bc67-7df87a295b0b"],
Cell[456715, 10954, 231, 4, 32, "Output",ExpressionUUID->"6c3751c0-7141-4c47-bb01-691833bfccba"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[457007, 10965, 157, 3, 38, "Subsection",ExpressionUUID->"4aa76cac-906f-7f45-be0d-637f51ee2a42"],
Cell[CellGroupData[{
Cell[457189, 10972, 320, 7, 28, "Input",ExpressionUUID->"66502e01-3006-f747-9027-cc757f2ca219"],
Cell[457512, 10981, 8803, 286, 122, "Output",ExpressionUUID->"d375dee9-5e6d-0c4b-902c-9db5c6f30228"]
}, Open  ]],
Cell[CellGroupData[{
Cell[466352, 11272, 281, 4, 45, "Subsubsection",ExpressionUUID->"9fee070d-03d8-a945-9741-930a44886dbd"],
Cell[CellGroupData[{
Cell[466658, 11280, 479, 12, 28, "Input",ExpressionUUID->"81a0a056-7f39-9340-9e68-d3c9445b1222"],
Cell[467140, 11294, 205, 4, 32, "Output",ExpressionUUID->"1d9d5fed-9313-9545-a5e3-d491ba39ed76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467382, 11303, 531, 13, 28, "Input",ExpressionUUID->"83f22c6f-435a-dc49-9aca-dd68d24544db"],
Cell[467916, 11318, 207, 4, 32, "Output",ExpressionUUID->"c5183373-bf98-f246-8125-a29b6a6aacbe"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[468184, 11329, 153, 3, 38, "Subsection",ExpressionUUID->"7579aa88-3a26-8748-be35-720b166befd2"],
Cell[CellGroupData[{
Cell[468362, 11336, 319, 7, 28, "Input",ExpressionUUID->"f62ef83e-680c-6046-8a24-8c0ea442b44e"],
Cell[468684, 11345, 13616, 424, 208, "Output",ExpressionUUID->"bf406471-8d2c-b74b-a70e-a59f874811bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[482337, 11774, 172, 3, 45, "Subsubsection",ExpressionUUID->"300446bc-29bf-9947-82af-ad97abd79581"],
Cell[CellGroupData[{
Cell[482534, 11781, 506, 12, 28, "Input",ExpressionUUID->"7994f72e-8089-0646-bbdb-7647c12b36e5"],
Cell[483043, 11795, 204, 4, 32, "Output",ExpressionUUID->"0620cb97-511b-b54d-bc97-7a2cdccfdf7e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[483308, 11806, 306, 5, 38, "Subsection",ExpressionUUID->"ec7f99ad-cd97-6841-a2aa-def813418c5d"],
Cell[CellGroupData[{
Cell[483639, 11815, 297, 7, 28, "Input",ExpressionUUID->"b104ed23-a86c-7b40-9d73-0247036a7461"],
Cell[483939, 11824, 22554, 662, 317, "Output",ExpressionUUID->"5c8d4769-62b9-3f4f-a40c-f9d6b909e3c8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[506530, 12491, 169, 3, 45, "Subsubsection",ExpressionUUID->"730aa00b-1790-4140-9299-5d331bed3f16"],
Cell[CellGroupData[{
Cell[506724, 12498, 600, 14, 28, "Input",ExpressionUUID->"9e043c6d-4717-4147-8f3d-1907a65579f6"],
Cell[507327, 12514, 540, 9, 32, "Output",ExpressionUUID->"c8f634d9-9047-a847-819b-727281d15cc5"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[507928, 12530, 330, 5, 38, "Subsection",ExpressionUUID->"2633372d-8391-634c-8e81-e1ce5610b771"],
Cell[508261, 12537, 342, 8, 28, "Input",ExpressionUUID->"13aa2c70-08df-de4d-9d1e-b89dda97dc04"],
Cell[CellGroupData[{
Cell[508628, 12549, 169, 3, 45, "Subsubsection",ExpressionUUID->"8af8dd32-3080-8c41-b091-ac7e373d678e"],
Cell[CellGroupData[{
Cell[508822, 12556, 600, 14, 28, "Input",ExpressionUUID->"6ec6dc4c-8b80-3c44-b090-79f3e979f085"],
Cell[509425, 12572, 322, 5, 32, "Output",ExpressionUUID->"acfd2fc1-4d35-df48-af88-4df13961fdc0"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[509808, 12584, 333, 5, 38, "Subsection",ExpressionUUID->"382534f7-ae81-104a-a54a-dd725e6c4322"],
Cell[CellGroupData[{
Cell[510166, 12593, 298, 7, 28, "Input",ExpressionUUID->"2bb42715-f2a5-db4e-ba25-c5c3a1865990"],
Cell[510467, 12602, 15333, 462, 208, "Output",ExpressionUUID->"a48fb83b-c052-8741-8f16-8c5b2e914d1e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525837, 13069, 169, 3, 45, "Subsubsection",ExpressionUUID->"d092eccb-c9cc-d249-80e8-25dec20dd82c"],
Cell[CellGroupData[{
Cell[526031, 13076, 682, 16, 28, "Input",ExpressionUUID->"96174ed5-f42b-b44b-b2c1-87afbe7eeb34"],
Cell[526716, 13094, 259, 5, 32, "Output",ExpressionUUID->"70c34d44-364b-c641-9e5e-97dcb9084dfb"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[527036, 13106, 307, 5, 38, "Subsection",ExpressionUUID->"e9ba3f29-2836-0e4e-ab8a-c890c90e17cb"],
Cell[CellGroupData[{
Cell[527368, 13115, 300, 7, 28, "Input",ExpressionUUID->"a651da95-8488-7c40-8bf3-8b03185c23c8"],
Cell[527671, 13124, 15219, 458, 208, "Output",ExpressionUUID->"b434c684-4ea8-a848-9ecf-5acb20df5357"]
}, Open  ]],
Cell[CellGroupData[{
Cell[542927, 13587, 169, 3, 45, "Subsubsection",ExpressionUUID->"1105f11d-30a3-5847-920b-97822c3dcdd8"],
Cell[543099, 13592, 682, 16, 28, "Input",ExpressionUUID->"71d4223f-cb25-9b45-ac01-6db1ce83a1ef"]
}, Open  ]],
Cell[543796, 13611, 231, 4, 32, "Output",ExpressionUUID->"0af2e1a1-f33d-ab44-8c90-6cf78aa91c4f"]
}, Closed]]
}, Closed]]
}
]
*)

